import {React, PureComponent, B, mix} from '../base';

import noop from '../../lib/noop';
import filter from '../../lib/filters/highSpeedTrain';

import Dropdown from '../Dropdown/Dropdown';
import CheckList from '../CheckList/CheckList';

import keyset from '../../i18n/filter-highspeed';

const b = B('FilterHighSpeedTrain');

export default class FilterHighSpeedTrain extends PureComponent {
    static defaultProps = {
        onChange: noop,
    };

    onChange = (e, {value}) => {
        this.updateFilter(value);
    };

    onButtonClick = () => {
        const {value = [], options} = this.props;

        this.updateFilter(
            value.length ? [] : options.length === 1 ? [options[0].value] : [],
        );
    };

    updateFilter(value) {
        this.props.onChange({
            type: filter.type,
            value,
        });
    }

    getButtonText() {
        const {value, options} = this.props;

        if (value.length === 0) {
            return keyset('highspeed-train');
        }

        const activeOptions = options.reduce(
            (optionsAccumulator, currentOption) => {
                if (value.includes(currentOption.value)) {
                    optionsAccumulator.push(currentOption.text);
                }

                return optionsAccumulator;
            },
            [],
        );

        return activeOptions.join(', ');
    }

    render() {
        const {className, value, options, activeOptions} = this.props;

        return (
            <Dropdown
                className={mix(b(), className)}
                inactive={activeOptions.length === 0}
                buttonText={this.getButtonText()}
                highlighted={value.length > 0}
                onOpen={this.onOpen}
            >
                <CheckList
                    className={b('options')}
                    value={value}
                    options={options}
                    activeOptions={activeOptions.map(option => option.value)}
                    onChange={this.onChange}
                />
            </Dropdown>
        );
    }
}
