import React, {memo, SyntheticEvent, useCallback} from 'react';
import B from 'bem-cn-lite';

import ILastochkaOptions from '../../interfaces/state/search/Filters/ILastochkaOptions';
import DateSpecialValue from '../../interfaces/date/DateSpecialValue';
import {FilterTransportType} from '../../lib/transportType';

import filter from '../../lib/filters/lastochka';
import getLastochkaUrl from '../../lib/url/getLastochkaUrl';
import {getCanonicalUrl} from '../../lib/url/searchUrl';
import useSelector from '../useSelector';

import ButtonCheckbox from '../ButtonCheckbox/ButtonCheckbox';

import keyset from '../../i18n/filter-lastochka';

const b = B('FilterLastochka');

interface IAction {
    type: string;
    value: boolean;
}

interface IFilterLastochkaProps {
    value: boolean;
    activeOptions: ILastochkaOptions;

    className?: string;
    onChange?(arg: IAction): void;
}

export default memo(FilterLastochka);

function FilterLastochka({
    value,
    activeOptions,
    className,
    onChange,
}: IFilterLastochkaProps): React.ReactElement | null {
    const context = useSelector(state => state.search.context);
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);
    const {canonical, transportType, when} = context;
    const isSuburbanToday =
        transportType === FilterTransportType.suburban &&
        when.special === DateSpecialValue.today;

    const onLinkClick = useCallback((e: SyntheticEvent): void => {
        e.preventDefault();
    }, []);
    const onClick = useCallback((): void => {
        const lastochkaFilterWillBeEnabled = !value;

        if (onChange) {
            onChange({
                type: filter.type,
                value: lastochkaFilterWillBeEnabled,
            });
        }
    }, [value, onChange]);

    const newUrl =
        isSuburbanToday && canonical
            ? value
                ? getCanonicalUrl(context, tld, language)
                : getLastochkaUrl(canonical.pointFrom, canonical.pointTo)
            : undefined;

    return (
        <div className={b(undefined, className)}>
            <ButtonCheckbox
                value={value}
                onClick={onClick}
                active={activeOptions.withLastochka}
            >
                {/* Сделано через <a>, чтобы на странице была нужная ссылка для роботов */}
                <a
                    className={b('link', {
                        inactive: !activeOptions.withLastochka,
                    })}
                    onClick={onLinkClick}
                    href={newUrl}
                >
                    {keyset('title')}
                </a>
            </ButtonCheckbox>
        </div>
    );
}
