import React, {memo, useCallback} from 'react';
import B from 'bem-cn-lite';

import ILastochkaOptions from '../../interfaces/state/search/Filters/ILastochkaOptions';

import filter from '../../lib/filters/lastochka';

// eslint-disable-next-line no-duplicate-imports
import ButtonCheckbox from '../ButtonCheckbox/ButtonCheckbox';

import keyset from '../../i18n/filter-lastochka';

const b = B('FilterLastochka');

interface IAction {
    type: string;
    value: boolean;
}

interface IFilterLastochkaProps {
    value: boolean;
    activeOptions: ILastochkaOptions;

    className?: string;
    onChange?(arg: IAction, newUrl?: string): void;
}

export default memo(FilterLastochka);

function FilterLastochka({
    value,
    activeOptions,
    className,
    onChange,
}: IFilterLastochkaProps): React.ReactElement | null {
    const onClick = useCallback((): void => {
        const lastochkaFilterWillBeEnabled = !value;

        if (onChange) {
            onChange({
                type: filter.type,
                value: lastochkaFilterWillBeEnabled,
            });
        }
    }, [value, onChange]);

    return (
        <div className={b(undefined, className)}>
            <ButtonCheckbox
                value={value}
                onClick={onClick}
                active={activeOptions.withLastochka}
                type="mobileFilterButton"
                width="100%"
            >
                {keyset('title')}
            </ButtonCheckbox>
        </div>
    );
}
