import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import noop from '../../lib/noop';
import filter from '../../lib/filters/pricePresence';

import ButtonCheckbox from '../ButtonCheckbox/ButtonCheckbox';

import keyset from '../../i18n/filter-price-presence';
import Platform from '../../interfaces/Platform';

const b = B('FilterPricePresence');
const isMobile = process.env.PLATFORM === Platform.mobile;

export default class FilterPricePresence extends PureComponent {
    onClick = () => {
        this.props.onChange({
            type: filter.type,
            value: !this.props.value,
        });
    };

    render() {
        const {className, value, availableWithActiveOptions} = this.props;

        return (
            <div className={b(undefined, className)}>
                <ButtonCheckbox
                    value={value}
                    onClick={this.onClick}
                    active={availableWithActiveOptions}
                    type={isMobile ? 'mobileFilterButton' : undefined}
                    width={isMobile ? '100%' : undefined}
                >
                    {keyset('with-price-only')}
                </ButtonCheckbox>
            </div>
        );
    }
}

FilterPricePresence.defaultProps = {
    onChange: noop,
};
