import {React, PureComponent, B, mix} from '../base';

import filterFrom from '../../lib/filters/stationFrom';
import filterTo from '../../lib/filters/stationTo';
import {PLANE_TYPE} from '../../lib/transportType';
import {reachGoalOnce} from '../../lib/yaMetrika';
import noop from '../../lib/noop';

import Dropdown from '../Dropdown/Dropdown';
import CheckList from '../CheckList/CheckList';

import keyset from '../../i18n/filter-station';

class FilterStation extends PureComponent {
    componentDidMount() {
        reachGoalOnce('filter_stations_show');
    }

    onOpen() {
        reachGoalOnce('filter_stations_click');
    }

    onChange = noop;

    render() {
        const {
            b,
            className,
            isMobile,
            value,
            options,
            activeOptions,
            transportTypes,
        } = this.props;

        const isPlaneSearch = transportTypes.every(item => item === PLANE_TYPE);

        return (
            <Dropdown
                className={mix(b('dropdown'), className)}
                isMobile={isMobile}
                inactive={!activeOptions.length}
                buttonText={keyset(isPlaneSearch ? 'title-plane' : 'title-all')}
                highlighted={value.length > 0}
                onOpen={this.onOpen}
            >
                <CheckList
                    value={value}
                    className={b('options')}
                    activeOptions={activeOptions.map(item => item.value)}
                    onChange={this.onChange}
                    options={options.sort((item, nextItem) =>
                        item.text.localeCompare(nextItem.text),
                    )}
                />
            </Dropdown>
        );
    }
}

FilterStation.defaultProps = {
    onChange: noop,
};

export class FilterStationsFrom extends FilterStation {
    onChange = (event, {value}) => {
        this.props.onChange({
            type: filterFrom.type,
            value,
        });
    };
}

FilterStationsFrom.defaultProps = {
    b: B('FilterStationsFrom'),
};

export class FilterStationsTo extends FilterStation {
    onChange = (event, {value}) => {
        this.props.onChange({
            type: filterTo.type,
            value,
        });
    };
}

FilterStationsTo.defaultProps = {
    b: B('FilterStationsTo'),
};
