import {React, PureComponent, B, mix} from '../base';

import filterTo from '../../lib/filters/stationTo';
import filterFrom from '../../lib/filters/stationFrom';
import {PLANE_TYPE} from '../../lib/transportType';
import noop from '../../lib/noop';

import Dropdown from '../Dropdown/Dropdown';
import CheckList from '../CheckList/CheckList';

import keyset from '../../i18n/filter-station';

const b = B('FilterStations');

export default class FilterStations extends PureComponent {
    onStationsFromChange = (event, {value}) => {
        this.props.onChange({
            type: filterFrom.type,
            value,
        });
    };

    onStationsToChange = (event, {value}) => {
        this.props.onChange({
            type: filterTo.type,
            value,
        });
    };

    getStationsList({value, options, activeOptions}, from) {
        return (
            <div className={b('stationBlock')}>
                <span className={b('blockTitle')}>
                    {keyset(`station-${from ? 'from' : 'to'}`)}
                </span>

                <CheckList
                    value={value}
                    className={b('options')}
                    activeOptions={activeOptions.map(item => item.value)}
                    onChange={
                        from
                            ? this.onStationsFromChange
                            : this.onStationsToChange
                    }
                    options={options.sort((item, nextItem) =>
                        item.text.localeCompare(nextItem.text),
                    )}
                />

                <div className={b('divider')} />
            </div>
        );
    }

    render() {
        const {className, stationTo, stationFrom, transportTypes} = this.props;

        const isPlaneSearch = transportTypes.every(item => item === PLANE_TYPE);
        const fromActiveOptions = stationFrom.activeOptions || [];
        const toActiveOptions = stationTo.activeOptions || [];
        const fromValue = stationFrom.value || [];
        const toValue = stationTo.value || [];

        return (
            <Dropdown
                className={mix(b('dropdown'), className)}
                inactive={!fromActiveOptions.length && !toActiveOptions.length}
                buttonText={keyset(isPlaneSearch ? 'title-plane' : 'title-all')}
                highlighted={Boolean(fromValue.length || toValue.length)}
                onOpen={this.onOpen}
            >
                {this.getStationsList(stationFrom, true)}
                {this.getStationsList(stationTo, false)}
            </Dropdown>
        );
    }
}

FilterStations.defaultProps = {
    onChange: noop,
};
