import {React, PureComponent, B, mix} from '../base';

import noop from '../../lib/noop';
import {reachGoal} from '../../lib/yaMetrika';

import Dropdown from '../Dropdown/Dropdown';
import FilterTimeOfDayContent from './FilterTimeOfDayContent';

import keyset from '../../i18n/filter-departure-arrival-time';

const b = B('FilterTimeOfDay');

export default class FilterTimeOfDay extends PureComponent {
    static defaultProps = {
        onChange: noop,
    };

    componentDidMount() {
        reachGoal('filter_timeofday_show');
    }

    render() {
        const {className, arrival, departure, onChange} = this.props;

        const arrivalIsAvailable = arrival.availableWithActiveOptions;
        const departureIsAvailable = departure.availableWithActiveOptions;
        const availableWithActiveOptions =
            arrivalIsAvailable || departureIsAvailable;
        const highlighted = Boolean(
            arrival.value.length || departure.value.length,
        );

        return (
            <Dropdown
                className={mix(b('dropdown'), className)}
                inactive={!availableWithActiveOptions}
                buttonText={keyset('button-text')}
                highlighted={highlighted}
                onOpen={this.onOpen}
            >
                <FilterTimeOfDayContent
                    arrival={arrival}
                    departure={departure}
                    onChange={onChange}
                    onMount={this.onContentDidMount}
                />
            </Dropdown>
        );
    }
}
