import {React, PureComponent, B, mix} from '../base';

import noop from '../../lib/noop';
import filter from '../../lib/filters/trainTariffClass';

import Dropdown from '../Dropdown/Dropdown';
import CheckList from '../CheckList/CheckList';

import filterKeyset from '../../i18n/filter-train-tariff-class';
import tariffClassKeyset from '../../i18n/tariffs-classes';

const b = B('FilterTrainTariffClass');

export default class FilterTrainTariffClass extends PureComponent {
    onChange = (e, {value}) => {
        this.props.onChange({
            type: filter.type,
            value,
        });
    };

    getTitle() {
        const {value} = this.props;

        if (value.length === 0) {
            return filterKeyset('title');
        }

        return value.map(tariffClassKeyset).join(', ');
    }

    getTariffClassName(tariffClass) {
        return tariffClassKeyset(tariffClass);
    }

    getOptions() {
        const {options} = this.props;

        return options.map(option => ({
            value: option,
            text: this.getTariffClassName(option),
        }));
    }

    render() {
        const {className, value, activeOptions} = this.props;

        return (
            <Dropdown
                className={mix(b(), className)}
                inactive={activeOptions.length === 0}
                buttonText={this.getTitle()}
                highlighted={value.length > 0}
                onOpen={this.onOpen}
            >
                <CheckList
                    className={b('options')}
                    value={value}
                    options={this.getOptions()}
                    activeOptions={activeOptions}
                    onChange={this.onChange}
                />
            </Dropdown>
        );
    }
}

FilterTrainTariffClass.defaultProps = {
    onChange: noop,
};
