import {React, PureComponent, B, mix} from '../base';

import noop from '../../lib/noop';
import filter from '../../lib/filters/transport';
import {getTransportTypeName} from '../../lib/transportType';

import Dropdown from '../Dropdown/Dropdown';
import CheckList from '../CheckList/CheckList';

import filterKeyset from '../../i18n/filter-transport';

const b = B('FilterTransport');

export default class FilterTransport extends PureComponent {
    onChange = (e, {value}) => {
        this.props.onChange({
            type: filter.type,
            value,
        });
    };

    getButtonText() {
        const {value} = this.props;

        if (value.length === 0) {
            return filterKeyset('title');
        }

        return value.map(item => getTransportTypeName(item)).join(', ');
    }

    getOptions() {
        const {options} = this.props;

        return options.map(option => ({
            value: option,
            text: getTransportTypeName(option),
        }));
    }

    render() {
        const {className, value, isMobile, activeOptions} = this.props;

        return (
            <Dropdown
                className={mix(b(), className)}
                isMobile={isMobile}
                inactive={activeOptions.length === 0}
                buttonText={this.getButtonText()}
                highlighted={value.length > 0}
                onOpen={this.onOpen}
            >
                <CheckList
                    className={b('options')}
                    value={value}
                    options={this.getOptions()}
                    activeOptions={activeOptions}
                    onChange={this.onChange}
                />
            </Dropdown>
        );
    }
}

FilterTransport.defaultProps = {
    onChange: noop,
};
