import {React, Component, B, mix} from '../base';

import {connect} from 'react-redux';

import {reachGoal} from '../../lib/yaMetrika';
import {resetFiltersValues} from '../../actions/search/filters';

import Button from '../Button/Button';

import keyset from '../../i18n/filters-reset';

const b = B('FiltersReset');

class FiltersReset extends Component {
    onClick = () => {
        reachGoal('filter_reset_click');
        this.props.dispatch(resetFiltersValues());
    };

    render() {
        const {className} = this.props;

        return (
            <Button className={mix(b(), className)} onClick={this.onClick}>
                {keyset('title')}
            </Button>
        );
    }
}

export default connect()(FiltersReset);
