import {React, PureComponent, B} from '../base';

import {connect} from 'react-redux';

import {updateFilterValue} from '../../actions/search/filters';

import FilterExpress from '../FilterExpress';
import FilterCarriers from '../FilterCarriers/FilterCarriers';
import FilterTransport from '../FilterTransport/FilterTransport';
import FilterHighSpeedTrain from '../FilterHighSpeedTrain/FilterHighSpeedTrain';
import FilterPricePresence from '../FilterPricePresence/FilterPricePresence';
import FilterStations from '../FilterStations/FilterStations';
import FilterAeroexpress from '../FilterAeroexpress/FilterAeroexpress';
import FilterLastochka from '../FilterLastochka/desktop';
import FilterTimeOfDay from '../FilterTimeOfDay';
import FilterTrainTariffClass from '../FilterTrainTariffClass/FilterTrainTariffClass';
import FiltersReset from '../FiltersReset/FiltersReset';

import {filtersWereApplied} from '../../lib/filters/filtering';

const b = B('FiltersToolbar');

const mapStateToProps = ({language}) => ({language});

class FiltersToolbar extends PureComponent {
    onFilterChange = action => {
        this.props.dispatch(updateFilterValue(action));
    };

    render() {
        const {
            filtering,
            transportTypes,
            queryingPrices,

            language,
        } = this.props;

        const {
            transport,
            express,
            pricePresence,
            carriers,
            stationFrom,
            stationTo,
            highSpeedTrain,
            lastochka,
            arrival,
            departure,
            aeroexpress,
            trainTariffClass,
        } = filtering.filters;
        const stations =
            stationFrom &&
            stationFrom.availableWithOptions &&
            stationTo &&
            stationTo.availableWithOptions;
        const timeOfDay =
            (departure && departure.availableWithOptions) ||
            (arrival && arrival.availableWithOptions);

        return (
            <>
                {transport && transport.availableWithOptions && (
                    <div className={b('item')}>
                        <FilterTransport
                            {...transport}
                            onChange={this.onFilterChange}
                            language={language}
                        />
                    </div>
                )}

                {lastochka && lastochka.availableWithOptions && (
                    <div className={b('item')}>
                        <FilterLastochka
                            onChange={this.onFilterChange}
                            value={lastochka.value}
                            activeOptions={lastochka.activeOptions}
                        />
                    </div>
                )}

                {highSpeedTrain && highSpeedTrain.availableWithOptions && (
                    <div className={b('item')}>
                        <FilterHighSpeedTrain
                            {...highSpeedTrain}
                            onChange={this.onFilterChange}
                            language={language}
                        />
                    </div>
                )}

                {pricePresence &&
                    (queryingPrices || pricePresence.availableWithOptions) && (
                        <div className={b('item')}>
                            <FilterPricePresence
                                {...pricePresence}
                                onChange={this.onFilterChange}
                                language={language}
                            />
                        </div>
                    )}

                {trainTariffClass && trainTariffClass.availableWithOptions && (
                    <div className={b('item')}>
                        <FilterTrainTariffClass
                            {...trainTariffClass}
                            onChange={this.onFilterChange}
                            language={language}
                        />
                    </div>
                )}

                {carriers && carriers.availableWithOptions && (
                    <div className={b('item')}>
                        <FilterCarriers
                            {...carriers}
                            onChange={this.onFilterChange}
                            language={language}
                        />
                    </div>
                )}

                {express && express.availableWithOptions && (
                    <div className={b('item')}>
                        <FilterExpress
                            {...express}
                            onChange={this.onFilterChange}
                            language={language}
                        />
                    </div>
                )}

                {aeroexpress && aeroexpress.availableWithOptions && (
                    <div className={b('item')}>
                        <FilterAeroexpress
                            {...aeroexpress}
                            onChange={this.onFilterChange}
                            language={language}
                        />
                    </div>
                )}

                {timeOfDay && (
                    <div className={b('item')}>
                        <FilterTimeOfDay
                            arrival={arrival}
                            departure={departure}
                            onChange={this.onFilterChange}
                        />
                    </div>
                )}

                {stations && (
                    <div className={b('item')}>
                        <FilterStations
                            language={language}
                            stationTo={stationTo}
                            stationFrom={stationFrom}
                            transportTypes={transportTypes}
                            onChange={this.onFilterChange}
                        />
                    </div>
                )}

                {filtersWereApplied(filtering) && (
                    <div className={b('item')}>
                        <FiltersReset />
                    </div>
                )}
            </>
        );
    }
}

export default connect(mapStateToProps)(FiltersToolbar);
