import {React, PureComponent, B} from '../base';

import IconGlyph from '../../interfaces/components/IconGlyph';

import {reachGoalOnce} from '../../lib/yaMetrika';
import tuneRegionUrl from '../../lib/url/tuneRegionUrl';

import Link from '../Link';
import Icon from '../Icon/Icon';

const b = B('GeoLink');

export default class GeoLink extends PureComponent {
    onClick() {
        reachGoalOnce('tune_region_click');
    }

    render() {
        const {userCity, fullUrl, tld} = this.props;

        return (
            <Link
                className={b()}
                colors="minorGray"
                onClick={this.onClick}
                href={tuneRegionUrl(tld, {retpath: fullUrl})}
                title={userCity}
            >
                <Icon className={b('arrow')} glyph={IconGlyph.geoArrow} />
                <span className={b('location')}>{userCity}</span>
            </Link>
        );
    }
}
