import {React, B} from '../base';

import {ReactNode, useEffect, useContext, memo} from 'react';
import {createPortal} from 'react-dom';

import GlobalPopupContext from '../Root/GlobalPopupContext';

const b = B('GlobalPopup');

interface IGlobalPopupProps {
    children: ReactNode;
}

export default memo(GlobalPopup);

function GlobalPopup({children = null}: IGlobalPopupProps): React.ReactElement {
    const {openGlobalPopup, closeGlobalPopup} = useContext(GlobalPopupContext);

    useEffect(() => {
        openGlobalPopup();
    }, [openGlobalPopup]);

    useEffect(() => {
        return () => {
            closeGlobalPopup();
        };
    }, [closeGlobalPopup]);

    const content = <div className={b()}>{children}</div>;

    const container = document.getElementById('globalPopupContainer');

    if (!container) {
        throw new Error('На странице отсутствует контейнер для попапа');
    }

    return createPortal(content, container);
}
