import {React, PureComponent, B, PropTypes, mix} from '../base';

import HeaderLogo from '../HeaderLogo/HeaderLogo';
import Personal from './Personal';

const b = B('LogoAndPersonal');

export default class LogoAndPersonal extends PureComponent {
    static propTypes = {
        tld: PropTypes.string.isRequired,
        language: PropTypes.string.isRequired,
        user: PropTypes.object.isRequired,
        page: PropTypes.object.isRequired,
        clientSettlement: PropTypes.object.isRequired,

        mods: PropTypes.object,
        className: PropTypes.string,
    };

    static defaultProps = {
        mods: {},
        className: '',
    };

    render() {
        const {tld, user, page, clientSettlement, mods, className} = this.props;

        return (
            <div className={mix(b(mods), className)}>
                <div className={b('logo')}>
                    <HeaderLogo tld={tld} isMobile />
                </div>

                <Personal
                    className={b('personal')}
                    tld={tld}
                    user={user}
                    page={page}
                    clientSettlement={clientSettlement}
                />
            </div>
        );
    }
}
