import React, {memo} from 'react';
import B from 'bem-cn-lite';

import Platform from '../../interfaces/Platform';

import useSelector from '../useSelector';

import User from '../User/User';
import Clock from '../Clock/Clock';
import GeoLink from '../GeoLink/GeoLink';
import OrdersLink from '../basic/OrdersLink';
import LoginButton from '../LoginButton/LoginButton';

const b = B('Personal');

interface IPersonalProps {
    className?: string;
    showTime?: boolean;
}

function Personal({className, showTime}: IPersonalProps): React.ReactElement {
    const clientSettlement = useSelector(state => state.clientSettlement);
    const page = useSelector(state => state.page);
    const tld = useSelector(state => state.tld);
    const user = useSelector(state => state.user);

    return (
        <div className={b(undefined, className)}>
            {process.env.PLATFORM === Platform.desktop && showTime && (
                <div className={b('regionTime')}>
                    <GeoLink
                        userCity={clientSettlement.title}
                        fullUrl={page.fullUrl}
                        tld={tld}
                    />

                    <Clock userTimezone={clientSettlement.timezone} />
                </div>
            )}

            <OrdersLink className={b('orders')} />

            <div className={b('user')}>
                {user.loggedIn ? (
                    <User {...user} tld={tld} fullUrl={page.fullUrl} />
                ) : (
                    <LoginButton tld={tld} fullUrl={page.fullUrl} />
                )}
            </div>
        </div>
    );
}

export default memo(Personal);
