import React, {memo} from 'react';
import B from 'bem-cn-lite';

import {SEARCH} from '../../routes/search';
import {HOME_PAGE_NAME} from '../../routes';
import {THREAD_PAGE_NAME} from '../../routes/thread';
import {STATION_PAGE_NAME} from '../../routes/station';

import {useFlags} from '../../../common/hooks/useFlags';

import Direct from '../Direct/Direct';
import NativeDirectBlock from '../NativeDirectBlock/NativeDirectBlock';

const DIRECT_ID_NATIVE_HEADER = 'R-I-239082-131';

const PAGES_WITH_MOBILE_DIRECT = [
    SEARCH,
    HOME_PAGE_NAME,
    THREAD_PAGE_NAME,
    STATION_PAGE_NAME,
];

const b = B('HeaderDirectBlock');

export interface IHeaderDirectBlockProps {
    pageType: string;
    isMobile: boolean;

    className?: string;
}

export default memo(HeaderDirectBlock);

function HeaderDirectBlock({
    pageType,
    isMobile,

    className,
}: IHeaderDirectBlockProps): React.ReactElement | null {
    const flags = useFlags();

    const {nativeTopId} = flags;

    const needDisplayNativeDirectInHeader =
        isMobile && PAGES_WITH_MOBILE_DIRECT.includes(pageType);

    if (!needDisplayNativeDirectInHeader) {
        return null;
    }

    const showDirect = pageType === SEARCH;

    return showDirect ? (
        <div className={b(undefined, className)}>
            <Direct blockId={nativeTopId || DIRECT_ID_NATIVE_HEADER} />
        </div>
    ) : (
        <div className={b(undefined, className)}>
            <NativeDirectBlock id={nativeTopId || DIRECT_ID_NATIVE_HEADER} />
        </div>
    );
}
