import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import Tld from '../../interfaces/Tld';
import IconGlyph from '../../interfaces/components/IconGlyph';

import Icon from '../Icon/Icon';
import ServiceLogo from '../ServiceLogo/ServiceLogo';
import YandexLogo from '../YandexLogo/YandexLogo';

const b = B('HeaderLogo');

interface IHeaderLogoProps {
    isMobile: boolean;
    tld: Tld;

    isFull?: boolean;
}

export default memo(HeaderLogo);

function HeaderLogo({
    isMobile,
    tld,

    isFull,
}: IHeaderLogoProps): ReactElement {
    return (
        <>
            <a className={b('yandexLink', {isMobile})} href={`//yandex.${tld}`}>
                {isFull ? (
                    <Icon
                        className={b('yandexText')}
                        glyph={IconGlyph.yandexText}
                    />
                ) : (
                    <YandexLogo
                        className={b('yandexLogo')}
                        width={isMobile ? 20 : 24}
                        height={isMobile ? 20 : 24}
                    />
                )}
            </a>
            <a className={b('serviceLink', {isMobile})} href="/">
                <ServiceLogo
                    width={isMobile ? 20 : 24}
                    height={isMobile ? 20 : 24}
                />
                <Icon
                    className={b('serviceName')}
                    glyph={IconGlyph.serviceName}
                />
            </a>
        </>
    );
}
