import {React, PureComponent, B} from '../base';

import PrintButton from '../PrintButton/PrintButton';
import LinkBackward from '../LinkBackward/LinkBackward';

const b = B('HelpLinks');

export default class HelpLinks extends PureComponent {
    render() {
        const {sort, compact, context, filtering, currencies} = this.props;

        const isDesktop = process.env.PLATFORM === 'desktop';

        return (
            <div className={b()}>
                <div className={b('item')}>
                    <LinkBackward
                        sort={sort}
                        compact={compact}
                        context={context}
                        filtering={filtering}
                        currencies={currencies}
                    />
                </div>

                {isDesktop && (
                    <div className={b('item')}>
                        <PrintButton compact={compact} />
                    </div>
                )}
            </div>
        );
    }
}

HelpLinks.defaultProps = {
    compact: false,
};
