import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';

import Direct from '../../Direct/Direct';

const b = B('DirectHome');

const TOP_DIRECT_ID = 'R-I-94177-4';
const BOTTOM_DIRECT_ID = 'R-I-94177-20';

export default class DirectHome extends PureComponent {
    state = {
        showBottomBlock: false,
        bottomBlockStyle: {},
    };

    onTopBlockRender = ({ref}) => {
        if (!ref || !ref.current) {
            return null;
        }

        const {width, height} = ref.current.getBoundingClientRect();

        if (height < 420) {
            this.setState({
                showBottomBlock: true,
                bottomBlockStyle: {width},
            });
        } else {
            this.setState({
                showBottomBlock: false,
            });
        }
    };

    render() {
        const {showBottomBlock, bottomBlockStyle} = this.state;
        const {
            flags: {
                idDirectHomeRightTopDesktop,
                idDirectHomeRightBottomDesktop,
            },
        } = this.props;

        const topBlockId = idDirectHomeRightTopDesktop || TOP_DIRECT_ID;
        const bottomBlockId =
            idDirectHomeRightBottomDesktop || BOTTOM_DIRECT_ID;

        return (
            <div className={b()}>
                <Direct
                    className={b('topBlock')}
                    blockId={topBlockId}
                    onRender={this.onTopBlockRender}
                    {...this.props}
                />

                {showBottomBlock && (
                    <Direct
                        className={b('bottomBlock')}
                        style={bottomBlockStyle}
                        blockId={bottomBlockId}
                        {...this.props}
                    />
                )}
            </div>
        );
    }
}
