import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';
import {useSelector} from 'react-redux';

import IState from '../../../interfaces/state/IState';
import ISettlement from '../../../interfaces/state/settlement/ISettlement';
import IDirection from '../../../interfaces/state/directions/IDirection';

import directionUrl from '../../../lib/url/directionUrl';

const b = B('DirectionItem');
const isMobile = process.env.PLATFORM === 'mobile';

interface IDirectionItem {
    data: IDirection;
    settlement: ISettlement;
}

export default memo(DirectionItem);

function DirectionItem({data, settlement}: IDirectionItem): ReactElement {
    const tld = useSelector((state: IState) => state.tld);
    const language = useSelector((state: IState) => state.language);

    const url = directionUrl(data.code, settlement.id, isMobile, tld, language);

    return (
        <li className={b({isMobile})}>
            <a href={url} className={b('link')}>
                {data.title}
            </a>
        </li>
    );
}
