import partition from 'lodash/partition';

import sortDirections from '../../../lib/sort/sortDirections';

function setDirections(result, directions, amountToShow) {
    if (directions.length <= amountToShow) {
        result.directionsToShow = directions;
    } else {
        result.directionsToShow = directions.slice(0, amountToShow);
        result.shownAll = false;
        result.notConnectedDirectionsCount =
            directions.length - result.directionsToShow.length;
    }

    return result;
}

export default function composeRenderData({
    isSuburbanZone,
    directions,
    showAll,
    nationalVersion,
    amountToShow = Infinity,
}) {
    const result = {
        directionsToShow: [],
        shownAll: true,
        notConnectedDirectionsCount: 0,
    };

    if (!directions.length) {
        return result;
    }

    const sortedDirections = sortDirections(
        directions,
        nationalVersion,
        amountToShow,
    );

    if (isSuburbanZone) {
        return setDirections(
            result,
            sortedDirections,
            showAll ? Infinity : amountToShow,
        );
    }

    const [connectedDirections, notConnectedDirections] = partition(
        sortedDirections,
        'connected',
    );

    return setDirections(
        result,
        [...connectedDirections, ...notConnectedDirections],
        showAll
            ? Infinity
            : amountToShow !== Infinity
            ? amountToShow
            : connectedDirections.length,
    );
}
