import {React, Component, B} from '../../base';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import DirectionsTitle from '../DirectionsTitle/DirectionsTitle';
import DirectionItem from '../DirectionItem';
import Button from '../../Button/Button';

import keyset from '../../../i18n/directions-menu';

import composeRenderData from './composeRenderData';
import isSuburbanZone from './isSuburbanZone';

const b = B('Directions');

export default class Directions extends Component {
    state = {
        showAll: false,
    };

    componentWillReceiveProps(nextProps) {
        if (nextProps.directions !== this.props.directions) {
            this.setState({
                showAll: false,
            });
        }
    }

    shouldComponentUpdate(nextProps, nextState) {
        const {directions} = this.props;
        const {showAll} = this.state;

        return (
            nextProps.directions !== directions || nextState.showAll !== showAll
        );
    }

    onShowAllButtonClick = () => {
        this.setState({
            showAll: true,
        });
    };

    render() {
        const {settlement, directions, nationalVersion} = this.props;
        const {showAll} = this.state;

        const {directionsToShow, shownAll, notConnectedDirectionsCount} =
            composeRenderData({
                isSuburbanZone: isSuburbanZone(settlement),
                directions,
                showAll,
                nationalVersion,
            });

        if (directionsToShow.length === 0) {
            return null;
        }

        const showAllButtonText = keyset('more', {
            count: notConnectedDirectionsCount,
        });

        return (
            <div className={b()}>
                <DirectionsTitle icon={IconGlyph.suburban}>
                    {keyset('title')}
                </DirectionsTitle>

                <ul className={b('list', {shownAll})}>
                    {directionsToShow.map(data => (
                        <DirectionItem
                            data={data}
                            key={data.code}
                            settlement={settlement}
                        />
                    ))}
                </ul>

                {!shownAll && (
                    <Button
                        className={b('showAllButton')}
                        onClick={this.onShowAllButtonClick}
                    >
                        {showAllButtonText}
                    </Button>
                )}
            </div>
        );
    }
}
