import React, {ReactElement, memo, PropsWithChildren} from 'react';
import B from 'bem-cn-lite';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import Icon from '../../Icon/Icon';

const b = B('DirectionsTitle');
const isMobile = process.env.PLATFORM === 'mobile';

interface IDirectionsTitle {
    icon: IconGlyph;

    className?: string;
}

export default memo(DirectionsTitle);

function DirectionsTitle({
    icon,

    children,
    className,
}: PropsWithChildren<IDirectionsTitle>): ReactElement {
    return (
        <h3 className={b({isMobile}, className)}>
            <Icon className={b('icon')} glyph={icon} />

            <span className={b('title')}>{children}</span>
        </h3>
    );
}
