import React, {memo, ReactElement, useCallback} from 'react';

import IApiBlablacarCityLinkResponse from '../../../../interfaces/api/IApiBlablacarCityLinkResponse';
import NationalVersion from '../../../../interfaces/NationalVersion';
import IconGlyph from '../../../../interfaces/components/IconGlyph';

import {reachGoal} from '../../../../lib/yaMetrika';
import addUtmTagsToBlablacarCityLink from '../../../../lib/url/addUtmTagsToBlablacarCityLink';

import ExternalService from '../ExternalService/ExternalService';

interface IBlaBlaCarService {
    blablacarLink: IApiBlablacarCityLinkResponse;
    text: string;
    nationalVersion: NationalVersion;
}

export default memo(BlaBlaCarService);

function BlaBlaCarService({
    blablacarLink: {banned, url},
    text,
    nationalVersion,
}: IBlaBlaCarService): ReactElement | null {
    const onClick = useCallback(() => {
        reachGoal('morda_blablacar_main_click');
    }, []);

    if (banned || !url) {
        return null;
    }

    return (
        <ExternalService
            url={addUtmTagsToBlablacarCityLink(url, nationalVersion)}
            text={text}
            iconGlyph={IconGlyph.blablacarLogo}
            onClick={onClick}
        />
    );
}
