import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';

import Icon from '../../../Icon/Icon';
import Link from '../../../Link';
import IconGlyph from '../../../../interfaces/components/IconGlyph';

const b = B('ExternalService');

interface IExternalService {
    url: string;
    text: string;
    iconGlyph: IconGlyph;

    onClick?: () => any;
    className?: string;
}

export default memo(ExternalService);

function ExternalService({
    url,
    text,
    iconGlyph,

    onClick,
    className,
}: IExternalService): ReactElement {
    return (
        <Link
            className={b(undefined, className)}
            href={url}
            target="_blank"
            rel="nofollow"
            onClick={onClick}
        >
            <Icon className={b('icon')} glyph={iconGlyph} />
            <span className={b('text')}>{text}</span>
        </Link>
    );
}
