import {React, PureComponent, PropTypes} from '../../../base';

import IconGlyph from '../../../../interfaces/components/IconGlyph';

import ExternalService from '../ExternalService/ExternalService';

import {composeUrl} from './routesService';

export default class RoutesService extends PureComponent {
    static propTypes = {
        ymapUrl: PropTypes.string.isRequired,
        text: PropTypes.string.isRequired,
    };

    render() {
        const {ymapUrl, text} = this.props;

        return (
            <ExternalService
                url={composeUrl(ymapUrl)}
                text={text}
                iconGlyph={IconGlyph.routes}
            />
        );
    }
}
