import React, {memo} from 'react';

import IconGlyph from '../../../../interfaces/components/IconGlyph';

import getTrainUrl from '../../../../lib/url/getTrainUrl';
import applyUtm from '../../../../lib/url/applyUtm';
import useSelector from '../../../useSelector';

import ExternalService from '../ExternalService/ExternalService';

interface ITrainServiceProps {
    text: string;
}

export default memo(TrainService);

function TrainService({text}: ITrainServiceProps): React.ReactElement {
    const isProduction = useSelector(state => state.environment.production);
    const seoQueryParams = useSelector(state => state.seoQueryParams);
    const clientId = useSelector(state => state.user.clientId);
    const patchedUrl = applyUtm(
        getTrainUrl({isProduction}),
        seoQueryParams,
        clientId,
        'main_train',
    );

    return (
        <ExternalService
            className="TrainService"
            url={patchedUrl}
            text={text}
            iconGlyph={IconGlyph.trainService}
        />
    );
}
