import {React, PureComponent, PropTypes, B} from '../../base';

import {
    TRAIN_TICKETS,
    PUBLIC_TRANSPORT,
} from '../../../lib/constants/homepageBlocks';

import shouldShowBlockForCountry from '../../../lib/shouldShowBlockForCountry';
import isRidesharingEnabled from '../../../lib/segments/ridesharing/isRidesharingEnabled';

import BlaBlaCarService from './BlaBlaCarService/BlaBlaCarService';
import RoutesService from './RoutesService';
import TrainService from './TrainService';

import keyset from '../../../i18n/external-services-menu';

const MOSCOW_REGION_ID = 1;

const b = B('ExternalServices');

export default class ExternalServices extends PureComponent {
    static propTypes = {
        settlement: PropTypes.object.isRequired,
        nationalVersion: PropTypes.string.isRequired,
        tld: PropTypes.string.isRequired,
        blablacarLink: PropTypes.object.isRequired,
        flags: PropTypes.object.isRequired,
    };

    render() {
        const {settlement, tld, nationalVersion, blablacarLink, flags} =
            this.props;

        const {ymap_url: ymapUrl, region_id: regionId} = settlement;
        const canShowBlaBlaCarService =
            isRidesharingEnabled(flags) && regionId !== MOSCOW_REGION_ID;

        return (
            <div className={b()}>
                {shouldShowBlockForCountry(TRAIN_TICKETS, tld) && (
                    <TrainService text={keyset('link-train')} />
                )}

                {canShowBlaBlaCarService && (
                    <BlaBlaCarService
                        nationalVerstion={nationalVersion}
                        blablacarLink={blablacarLink}
                        text={keyset('link-blablacar')}
                    />
                )}

                {ymapUrl &&
                    shouldShowBlockForCountry(PUBLIC_TRANSPORT, tld) && (
                        <RoutesService
                            ymapUrl={ymapUrl}
                            text={keyset('link-routes')}
                        />
                    )}
            </div>
        );
    }
}
