import {React, PureComponent, B} from '../../base';

import {HUMAN_DATE_WITH_WEEKDAY} from '../../../lib/date/formats';
import {getMomentDate, getNow} from '../../../lib/date/utils';

import Clock from '../../Clock/Clock';
import ChangeCity from '../ChangeCity/desktop';

import timeKeyset from '../../../i18n/timezones';

const b = B('GeoBlock');

export default class GeoBlock extends PureComponent {
    render() {
        const {
            clientSettlement,
            currentSettlement,
            suggests,
            nationalVersion,
            tld,
            page,
        } = this.props;
        const {timezone} = currentSettlement;
        const date = getMomentDate(getNow(), timezone);

        const dateFormated = date.format(HUMAN_DATE_WITH_WEEKDAY);

        return (
            <div className={b()}>
                <ChangeCity
                    clientSettlement={clientSettlement}
                    currentSettlement={currentSettlement}
                    suggests={suggests}
                    nationalVersion={nationalVersion}
                    tld={tld}
                    page={page}
                />

                <div className={b('date')}>
                    {dateFormated}
                    {`, ${timeKeyset('local-time')} `}
                    <Clock userTimezone={timezone} />
                </div>
            </div>
        );
    }
}
