import {React, PureComponent, B} from '../../base';

import changeUrl from 'page';

import {CITY} from '../../../lib/constants/suggestOptionTypes';
import {HUMAN} from '../../../lib/date/formats';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import {getMomentDate, getNow} from '../../../lib/date/utils';
import defaultDataProvider from '../../../lib/suggests/defaultDataProvider';
import getDataProviderOptions from '../../../lib/suggests/getDataProviderOptions';
import cityUrl from '../../../lib/url/getCityUrl';

import Clock from '../../Clock/Clock';
import Icon from '../../Icon/Icon';
import Button from '../../Button/Button';
import Suggest from '../../Suggest/Suggest';
import GlobalPopup from '../../GlobalPopup';

import tuneRegionKeyset from '../../../i18n/tune-region';
import keyset from '../../../i18n/city-change-form';

const b = B('GeoBlock');

export default class GeoBlock extends PureComponent {
    static defaultProps = {
        value: {
            title: '',
            key: '',
        },
        dataProvider: defaultDataProvider,
    };

    state = {
        suggestField: null,
        userInput: {
            title: '',
            key: '',
        },
    };

    onClick = () => {
        this.showSuggest();
    };

    onChange = (field, value) => {
        this.setState({userInput: value});
    };

    showSuggest = () => {
        this.setState({
            suggestField: CITY,
        });
    };

    hideSuggest = () => {
        this.setState({
            suggestField: undefined,
        });
    };

    selectSuggest = value => {
        const {key} = value;
        const idToApply = key.substr(1);

        changeUrl(cityUrl(idToApply));

        this.hideSuggest();
    };

    getInputData = () => {
        const {userInput} = this.state;

        return {
            userInput: {
                city: userInput,
            },
        };
    };

    render() {
        const {suggestField} = this.state;
        const {
            clientSettlement,
            currentSettlement,
            suggests,
            nationalVersion,
            language,
        } = this.props;
        const {timezone} = currentSettlement;
        const dataProviderOptionsObject = {
            suggests,
            nationalVersion,
            settlement: clientSettlement,
            language,
            path: CITY,
        };
        const date = getMomentDate(getNow(), timezone);

        const dateFormated = `${date.format(HUMAN)}, `;
        const arrow = (
            <Icon className={b('arrow')} glyph={IconGlyph.geoArrow} />
        );

        return (
            <div className={b()}>
                <div className={b('current')} onClick={this.onClick}>
                    {arrow}
                    <div className={b('title')}>{currentSettlement.title}</div>
                </div>

                <div className={b('date')}>
                    {dateFormated}
                    <Clock userTimezone={timezone} />
                </div>

                <div className={b('changeCity')}>
                    <Button
                        onClick={this.onClick}
                        className={b('touchTitleButton')}
                    >
                        {tuneRegionKeyset('button')}
                    </Button>

                    {suggestField && (
                        <GlobalPopup>
                            <Suggest
                                dataProviderOptions={getDataProviderOptions(
                                    dataProviderOptionsObject,
                                )}
                                inputData={this.getInputData()}
                                suggestField={suggestField}
                                hide={this.hideSuggest}
                                select={this.selectSuggest}
                                formKeyset={keyset}
                                onChange={this.onChange}
                            />
                        </GlobalPopup>
                    )}
                </div>
            </div>
        );
    }
}
