import React, {memo} from 'react';
import B from 'bem-cn-lite';

import Direction from '../../../interfaces/Direction';
import ISettlement from '../../../interfaces/state/settlement/ISettlement';
import IStatePopularDirections from '../../../interfaces/state/popularDirections/IStatePopularDirections';
import Tld from '../../../interfaces/Tld';
import Lang from '../../../interfaces/Lang';

import {reachGoal} from '../../../lib/yaMetrika';
import useSelector from '../../../components/useSelector';
import getCanonicalPopularDirectionUrl from '../../../lib/url/getCanonicalPopularDirectionUrl';

import Spinner from '../../../components/Spinner/Spinner';
import Link from '../../../components/Link';

import popularDirectionKeyset from '../../../i18n/popular-directions';

const b = B('PopularDirections');

interface IPopularDirectionColumnParams {
    popularDirections: IStatePopularDirections;
    settlement: ISettlement;
    direction: Direction;
    tld: Tld;
    language: Lang;
}

const onClick = (): void => {
    reachGoal('morda_popular_direction_click');
};

function popularDirectionColumn({
    popularDirections,
    settlement,
    direction,
    tld,
    language,
}: IPopularDirectionColumnParams): React.ReactElement {
    return (
        <div className={b('column')}>
            <h4 className={b('columnTitle')}>
                {popularDirections[direction].title}
            </h4>

            {popularDirections[direction].points.map((point, index) => {
                const {directionTitle} = point;

                return (
                    <Link
                        key={index}
                        className={b('link')}
                        href={getCanonicalPopularDirectionUrl({
                            point,
                            direction,
                            slug: settlement.slug,
                            language,
                            tld,
                        })}
                        onClick={onClick}
                    >
                        {directionTitle}
                    </Link>
                );
            })}
        </div>
    );
}

interface IPopularDirectionsParams {
    popularDirections: IStatePopularDirections;
    settlement: ISettlement;
}

export default memo(PopularDirections);

function PopularDirections({
    popularDirections,
    settlement,
}: IPopularDirectionsParams): React.ReactElement {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);

    // при переходе со страницы поиска нет данных о популярных направлениях
    // они запрашиваются асинхронно
    const showSpinner =
        !popularDirections[Direction.from] || !popularDirections[Direction.to];

    return (
        <div className={b()}>
            <h3 className={b('title')}>{popularDirectionKeyset('title')}</h3>

            {showSpinner ? (
                <Spinner size="normal" />
            ) : (
                <div className={b('point-columns')}>
                    {popularDirectionColumn({
                        popularDirections,
                        settlement,
                        direction: Direction.from,
                        tld,
                        language,
                    })}

                    {popularDirectionColumn({
                        popularDirections,
                        settlement,
                        direction: Direction.to,
                        tld,
                        language,
                    })}
                </div>
            )}
        </div>
    );
}
