import React, {memo} from 'react';
import B from 'bem-cn-lite';

import Direction from '../../../interfaces/Direction';
import Tld from '../../../interfaces/Tld';
import Lang from '../../../interfaces/Lang';
import ISettlement from '../../../interfaces/state/settlement/ISettlement';
import IStatePopularDirections from '../../../interfaces/state/popularDirections/IStatePopularDirections';

import getCanonicalPopularDirectionUrl from '../../../lib/url/getCanonicalPopularDirectionUrl';
import useSelector from '../../useSelector';
import {reachGoal} from '../../../lib/yaMetrika';

import Link from '../../../components/Link';
import Spinner from '../../../components/Spinner/Spinner';

import popularDirectionKeyset from '../../../i18n/popular-directions';

const b = B('PopularDirections');

interface IPopularDirectionsParams {
    popularDirections: IStatePopularDirections;
    settlement: ISettlement;
}

interface IGetPopularDirectionColumnParams {
    popularDirections: IStatePopularDirections;
    direction: Direction;
    settlement: ISettlement;
    language: Lang;
    tld: Tld;
}

function onClick(): void {
    reachGoal('morda_popular_direction_click');
}

function getPopularDirectionColumn({
    popularDirections,
    direction,
    settlement,
    language,
    tld,
}: IGetPopularDirectionColumnParams): React.ReactElement {
    return (
        <div className={b('popularDirectionColumn')}>
            <h4 className={b('directionTitle')}>
                {popularDirections[direction].title}
            </h4>

            {popularDirections[direction].points.map((point, index) => {
                const {directionTitle} = point;

                return (
                    <Link
                        key={index}
                        className={b('link')}
                        href={getCanonicalPopularDirectionUrl({
                            point,
                            direction,
                            slug: settlement.slug,
                            language,
                            tld,
                        })}
                        onClick={onClick}
                        colors="inherit"
                    >
                        {directionTitle}
                    </Link>
                );
            })}
        </div>
    );
}

export default memo(PopularDirections);

function PopularDirections({
    popularDirections,
    settlement,
}: IPopularDirectionsParams): React.ReactElement {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);

    // при переходе со страницы поиска нет данных о популярных направлениях
    // они запрашиваются асинхронно
    const showSpinner =
        !popularDirections[Direction.from] || !popularDirections[Direction.to];

    return (
        <div className={b()}>
            <h3 className={b('title')}>{popularDirectionKeyset('title')}</h3>

            {showSpinner ? (
                <div className={b('spinnerWrapper')}>
                    <Spinner size="normal" />
                </div>
            ) : (
                <>
                    {getPopularDirectionColumn({
                        popularDirections,
                        direction: Direction.from,
                        settlement,
                        language,
                        tld,
                    })}

                    {getPopularDirectionColumn({
                        popularDirections,
                        direction: Direction.to,
                        settlement,
                        language,
                        tld,
                    })}
                </>
            )}
        </div>
    );
}
