import React, {memo} from 'react';
import B from 'bem-cn-lite';

import Platform from '../../../interfaces/Platform';
import IStation from '../../../interfaces/state/stationsGroup/IStation';

import {stationUrl} from '../../../lib/url/stationUrl';
import useSelector from '../../useSelector';

import Link from '../../Link';

const b = B('Station');
const isMobile = process.env.PLATFORM === Platform.mobile;

interface IStationParams {
    station: IStation;
    status: string | null;

    usePopularTitle?: boolean;
}

export default memo(Station);

function Station({
    station,
    status,
    usePopularTitle,
}: IStationParams): React.ReactElement {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);

    return (
        <li className={b({isMobile})}>
            <Link
                className={b('link')}
                href={stationUrl({id: station.id, isMobile, tld, language})}
            >
                <div className={b('title')}>
                    {usePopularTitle ? station.popular_title : station.title}

                    {status && <span className={b('status')}>{status}</span>}
                </div>
            </Link>
        </li>
    );
}
