import {React, B} from '../../base';

import {connect} from 'react-redux';

import SecondaryPosition from '../../../interfaces/lib/dimensions/SecondaryPosition';
import PrimaryPosition from '../../../interfaces/lib/dimensions/PrimaryPosition';
import IconGlyph from '../../../interfaces/components/IconGlyph';

import {stationUrl} from '../../../lib/url/stationUrl';
import {glyphsByTransportType} from '../../TransportIcon/TransportIcon';

import Button from '../../Button/Button';
import DirectionsTitle from '../DirectionsTitle/DirectionsTitle';
import Popup from '../../Popup/Popup';
import Link from '../../Link';
import Arrow from '../../Arrow/Arrow';
import Icon from '../../Icon/Icon';
import PopupTogglerComponent from '../../_mixins/PopupTogglerComponent';

const b = B('StationsDropdown');

const isMobile = process.env.PLATFORM === 'mobile';

const POPUP_POSITIONS = [
    [PrimaryPosition.right, SecondaryPosition.top],
    [PrimaryPosition.right, SecondaryPosition.center],
    [PrimaryPosition.right, SecondaryPosition.bottom],
];

const MANY_ITEMS_LIMIT = 15;

const mapStateToProps = ({tld, language}) => ({
    tld,
    language,
});

class StationsDropdown extends PopupTogglerComponent {
    render() {
        const {buttonText, stations, type, tld, language} = this.props;
        const {popupVisible} = this.state;

        const manyItems = stations.length > MANY_ITEMS_LIMIT;

        return (
            <div className={b({opened: popupVisible, manyItems})}>
                <Button className={b('toggler')} onClick={this.onTogglerClick}>
                    <DirectionsTitle
                        icon={glyphsByTransportType[type]}
                        className={b('title')}
                    >
                        {buttonText}
                    </DirectionsTitle>

                    <Arrow className={b('arrow')} />
                </Button>

                <Popup
                    visible={popupVisible}
                    className={b('popup')}
                    onClickOutside={this.onPopupClickOutside}
                    positions={POPUP_POSITIONS}
                    withoutArrow
                >
                    <ul className={b('list')}>
                        {stations.map(station => (
                            <li key={station.id} className={b('list-item')}>
                                <Link
                                    className={b('link')}
                                    href={stationUrl({
                                        id: station.id,
                                        isMobile,
                                        tld,
                                        language,
                                    })}
                                >
                                    {station.is_metro && (
                                        <span className={b('link-icon')}>
                                            <Icon
                                                className={b('metro-icon')}
                                                glyph={IconGlyph.metro}
                                            />
                                        </span>
                                    )}

                                    {station.title}
                                </Link>
                            </li>
                        ))}
                    </ul>
                </Popup>
            </div>
        );
    }
}

export default connect(mapStateToProps)(StationsDropdown);
