import React from 'react';
import B from 'bem-cn-lite';

import {TransportType} from '../../../lib/transportType';
import IStation from '../../../interfaces/state/stationsGroup/IStation';

import {stationUrl} from '../../../lib/url/stationUrl';
import {shouldShowAeroexpress} from '../../../lib/aeroexpress';
import {glyphsByTransportType} from '../../TransportIcon/TransportIcon';

import {useTld} from '../../../hooks/useTld';
import {useLang} from '../../../hooks/useLang';

import Link from '../../Link';
import Aeroexpress from '../Aeroexpress/Aeroexpress';
import DirectionsTitle from '../DirectionsTitle/DirectionsTitle';
import StationsDropdown from '../StationsDropdown/StationsDropdown';

const b = B('StationsGroupTitle');
const isMobile = process.env.PLATFORM === 'mobile';

interface IStationsGroupTitleProps {
    stations: IStation[];
    type: TransportType;
    title: string;
    status: string | null;

    hasPopup?: boolean;
}

const StationsGroupTitle: React.FC<IStationsGroupTitleProps> = props => {
    const {stations, type, title, hasPopup, status} = props;
    const tld = useTld();
    const language = useLang();

    const onlyOneStation = stations.length === 1;
    const showAeroexpress = shouldShowAeroexpress(stations, type) && !isMobile;

    // hasPopup символизирует, что станций больше, чем мы готовы показывать на странице
    if (hasPopup) {
        return (
            <div className={b()}>
                <StationsDropdown
                    buttonText={title}
                    stations={stations}
                    type={type}
                />
            </div>
        );
    }

    return (
        <div className={b({showAeroexpress})}>
            <DirectionsTitle
                className={b('title', {isMobile})}
                icon={glyphsByTransportType[type]}
            >
                {onlyOneStation ? (
                    <Link
                        className={b('link')}
                        href={stationUrl({
                            id: stations[0].id,
                            isMobile,
                            tld,
                            language,
                        })}
                    >
                        {title}

                        {status && <div className={b('status')}>{status}</div>}
                    </Link>
                ) : (
                    title
                )}
            </DirectionsTitle>

            {showAeroexpress && (
                <Aeroexpress
                    stations={stations}
                    language={language}
                    tld={tld}
                />
            )}
        </div>
    );
};

export default StationsGroupTitle;
