import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import ITeaserFromApi from '../../../interfaces/state/teasers/ITeaserFromApi';

import Teaser from '../../Teaser';

const b = B('Teasers');

interface ITeasers {
    teasers: ITeaserFromApi[];

    className?: string;
}

export default memo(Teasers);

function Teasers({
    teasers,

    className,
}: ITeasers): ReactElement | null {
    if (!teasers.length) {
        return null;
    }

    return (
        <div className={b(undefined, className)}>
            {teasers.map((teaser, i) => (
                <Teaser className={b('item')} key={i} {...teaser} />
            ))}
        </div>
    );
}
