import {React, PureComponent, B} from '../base';

import AdFoxPosition from '../../interfaces/components/adFox/AdFoxPosition';
import AdFoxType from '../../interfaces/components/adFox/AdFoxType';

import GeoBlock from './GeoBlock';
import Directions from './Directions';
import Stations from '../Stations/Stations.desktop';

import StationSearch from './StationSearch';
import PopularDirections from './PopularDirections/PopularDirections.desktop';
import Teasers from './Teasers/Teasers';
import ExternalServices from './ExternalServices';
import DirectHome from './DirectHome';
import AdFoxBanner from '../AdFoxBanner/AdFoxBanner';

const b = B('HomePage');

export default class HomePage extends PureComponent {
    render() {
        const {
            clientSettlement,
            currentSettlement,
            directions,
            popularDirections,
            suggests,
            nationalVersion,
            tld,
            page,
            stationsGroup,
            teasers,
            home: {blablacarLink},
            language,
            flags,
        } = this.props;

        return (
            <div className={b()}>
                <AdFoxBanner
                    position={AdFoxPosition.center}
                    type={AdFoxType.inline}
                />

                <GeoBlock
                    clientSettlement={clientSettlement}
                    currentSettlement={currentSettlement}
                    suggests={suggests}
                    nationalVersion={nationalVersion}
                    tld={tld}
                    page={page}
                />

                <div className={b('content')}>
                    <div className={b('column', {left: true})}>
                        <div className={b('leftColumnContent')}>
                            <Directions
                                directions={directions}
                                settlement={currentSettlement}
                                nationalVersion={nationalVersion}
                            />

                            <Stations stationsGroup={stationsGroup} />
                        </div>
                    </div>

                    <div className={b('column')}>
                        <StationSearch
                            settlement={currentSettlement}
                            nationalVersion={nationalVersion}
                            suggests={suggests}
                            language={language}
                        />

                        <Teasers className={b('teasers')} teasers={teasers} />

                        <PopularDirections
                            popularDirections={popularDirections}
                            settlement={currentSettlement}
                        />

                        <ExternalServices
                            settlement={currentSettlement}
                            nationalVersion={nationalVersion}
                            tld={tld}
                            blablacarLink={blablacarLink}
                            flags={flags}
                        />
                    </div>

                    <div className={b('column', {right: true})}>
                        <DirectHome flags={flags} />
                    </div>
                </div>
            </div>
        );
    }
}
