import {React, PureComponent, B} from '../base';

import {connect} from 'react-redux';

import GeoBlock from './GeoBlock';
import Directions from './Directions';
import Stations from '../Stations/Stations.mobile';
import StationSearch from './StationSearch';
import Direct from '../Direct/Direct';
import SegmentBottomSheet from '../search/SegmentBottomSheet';
import DescriptionHome from '../layout/HomeLayout/DescriptionHome';
import PopularDirections from './PopularDirections/PopularDirections.mobile';

const b = B('HomePage');
const SMARTBANNER_ID = 'Y-A-341252-1';
const DIRECT_ID = 'R-I-239082-1';
const DIRECT_ID_EVERLASTING_EXPERIMENT = 'R-I-239082-15';

const mapStateToProps = ({flags}) => ({flags});

class HomePage extends PureComponent {
    getDirectId() {
        const {
            flags: {__everlastingHomeTouchExperiment, idDirectHomeFooterTouch},
        } = this.props;

        return (
            idDirectHomeFooterTouch ||
            (__everlastingHomeTouchExperiment
                ? DIRECT_ID_EVERLASTING_EXPERIMENT
                : DIRECT_ID)
        );
    }

    render() {
        const {
            clientSettlement,
            currentSettlement,
            popularDirections,
            directions,
            suggests,
            nationalVersion,
            tld,
            page,
            home,
            language,
            stationsGroup,
        } = this.props;
        const {isCity} = home;

        return (
            <div className={b()}>
                <GeoBlock
                    clientSettlement={clientSettlement}
                    currentSettlement={currentSettlement}
                    suggests={suggests}
                    nationalVersion={nationalVersion}
                    tld={tld}
                    page={page}
                />

                <div className={b('content')}>
                    <div className={b('directionsBlock')}>
                        <Directions
                            directions={directions}
                            settlement={currentSettlement}
                            nationalVersion={nationalVersion}
                        />

                        <Stations
                            stationsGroup={stationsGroup}
                            cityId={currentSettlement?.id}
                        />

                        <PopularDirections
                            popularDirections={popularDirections}
                            settlement={currentSettlement}
                        />
                    </div>

                    <StationSearch
                        settlement={currentSettlement}
                        nationalVersion={nationalVersion}
                        suggests={suggests}
                        language={language}
                        tld={tld}
                    />

                    <DescriptionHome
                        currentSettlement={currentSettlement}
                        stationsGroup={stationsGroup}
                        isCity={isCity}
                        tld={tld}
                    />

                    <Direct blockId={this.getDirectId()} />

                    <Direct
                        blockId={SMARTBANNER_ID}
                        format="popup"
                        position="relative"
                        className={b('smartbanner')}
                    />
                </div>

                <SegmentBottomSheet />
            </div>
        );
    }
}

export default connect(mapStateToProps)(HomePage);
