import React, {memo, MouseEvent} from 'react';
import B from 'bem-cn-lite';

import IconGlyph from '../../interfaces/components/IconGlyph';
import IconGlyphInformers from '../../interfaces/components/IconGlyphInformers';

type AnyFunction = (...param: any[]) => any;

const b = B('Icon');

interface IIcon {
    [key: string]:
        | string
        | number
        | boolean
        | undefined
        | AnyFunction
        | Record<string, string>;
    glyph: IconGlyph | IconGlyphInformers;

    className?: string;
    onClick?: (e: MouseEvent<SVGElement>) => void;
    flexShrinkZero?: boolean;
}

export default memo(Icon);

function Icon({
    glyph,

    className,
    onClick,
    flexShrinkZero = true,
    ...rest
}: IIcon): React.ReactElement {
    return (
        <svg
            {...rest}
            className={b({flexShrinkZero}, className)}
            onClick={onClick}
            dangerouslySetInnerHTML={{
                __html: `<use xlink:href="#icon-${glyph}" />`,
            }}
        />
    );
}
