import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

import Platform from '../../interfaces/Platform';

import useSelector from '../useSelector';
import getInfoUrl from '../../lib/url/getInfoUrl';

import Link from '../Link';
import LoadingChunk from '../basic/LoadingChunk';

const b = B('InfoPage');
const isMobile = process.env.PLATFORM === Platform.mobile;

export default memo(InfoPage);

function InfoPage(): ReactElement {
    const tld = useSelector(state => state.tld);
    const language = useSelector(state => state.language);
    const title = useSelector(state => state.info.title);
    const content = useSelector(state => state.info.content);
    const children = useSelector(state => state.info.children);
    const fetching = useSelector(state => state.page.fetching);

    if (fetching) {
        return (
            <div className={b({isMobile})}>
                <LoadingChunk />
            </div>
        );
    }

    return (
        <div className={b({isMobile})}>
            <h1 className={b('title')}>{title}</h1>

            {Boolean(children.length) && (
                <ul>
                    {children.map(
                        ({slug: childSlug, id: childId, title: childTitle}) => (
                            <li key={childSlug}>
                                <Link
                                    href={getInfoUrl(
                                        childSlug || childId,
                                        tld,
                                        language,
                                    )}
                                >
                                    {childTitle}
                                </Link>
                            </li>
                        ),
                    )}
                </ul>
            )}

            <div
                className={b('content')}
                dangerouslySetInnerHTML={{__html: content}}
            />
        </div>
    );
}
