import React, {memo} from 'react';
import B from 'bem-cn-lite';

import {CHAR_EM_DASH} from '../../lib/stringUtils';

import InformerTheme from '../../interfaces/components/informer/InformerTheme';

import Link from '../Link';

import needCutStations from '../SearchInformer/needCutStations';

const b = B('InformerDirectionTitle');

interface IInformerDirectionTitleParams {
    title: string;

    href?: string;
    className?: string;
    theme?: InformerTheme;
}

export default memo(InformerDirectionTitle);

function InformerDirectionTitle({
    title,

    href,
    className,
    theme,
}: IInformerDirectionTitleParams): React.ReactElement {
    const [titleStationFrom, titleStationTo] = title.split(CHAR_EM_DASH) as [
        string,
        string | undefined,
    ];
    const {
        needCutStationFrom: needCutTitleStationFrom,
        needCutStationTo: needCutTitleStationTo,
    } = needCutStations({
        stationFrom: titleStationFrom,
        stationTo: titleStationTo,
    });

    const linkColor = theme === InformerTheme.black ? 'textPrimary' : undefined;

    return !titleStationTo ? (
        <Link
            className={b(undefined, className)}
            href={href}
            target="_blank"
            colors={linkColor}
        >
            <span className={b('text')}>{title}</span>
        </Link>
    ) : (
        <Link
            className={b({splitted: Boolean(titleStationTo)}, className)}
            href={href}
            target="_blank"
            colors={linkColor}
        >
            <span className={b('text')}>
                <span
                    className={b('stationFrom', {cut: needCutTitleStationFrom})}
                >
                    {titleStationFrom}
                </span>
                {CHAR_EM_DASH}
                <span className={b('stationTo', {cut: needCutTitleStationTo})}>
                    {titleStationTo}
                </span>
            </span>
        </Link>
    );
}
