import {React, PureComponent, B, refCallback} from '../base';

import {LANGUAGE_TITLES, COUNTRY_CODES} from '../../lib/lang/langCodes';

import makeExternalUrl from '../../lib/url/makeExternalUrl';
import langSwitchUrl from '../../lib/url/langSwitchUrl';
import {reachGoal} from '../../lib/yaMetrika';

import Link from '../Link';
import CountryFlag from '../CountryFlag/CountryFlag';

const b = B('LangSwitcher');

export default class LangSwitcher extends PureComponent {
    state = {
        opened: false,
    };

    onTogglerClick = e => {
        if (e.ctrlKey || e.metaKey) {
            return;
        }

        e.preventDefault();

        if (this.state.opened) {
            this.close();
        } else {
            this.open();
        }
    };

    onDocumentClick = e => {
        if (!this._self.contains(e.target)) {
            this.close();
        }
    };

    onLinkClick(e) {
        const {currentTarget} = e;

        reachGoal('lang-switch-click', {
            lang: currentTarget.getAttribute('data-language'),
            url: window.location.href,
        });
    }

    open() {
        document.addEventListener('click', this.onDocumentClick);
        this.setState({opened: true});
    }

    close() {
        document.removeEventListener('click', this.onDocumentClick);
        this.setState({opened: false});
    }

    getFullUrl() {
        const {page} = this.props;
        const {originUrl, location} = page;
        const query = location.query;

        delete query.lang;

        return makeExternalUrl(`${originUrl}${location.pathname}`, query);
    }

    render() {
        const {tld, user, language, availableLanguages} = this.props;

        const fullUrl = this.getFullUrl();

        const {secretkey} = user;

        const {opened} = this.state;

        const togglerUrl = makeExternalUrl(
            `//www.yandex.${tld}/portal/set/lang/`,
            {retpath: fullUrl},
        );

        return (
            <div className={b({opened})} ref={refCallback(this, '_self')}>
                <Link
                    className={b('toggler')}
                    href={togglerUrl}
                    onClick={this.onTogglerClick}
                >
                    <CountryFlag
                        className={b('flag')}
                        countryCode={COUNTRY_CODES[language]}
                    />

                    {LANGUAGE_TITLES[language]}
                </Link>

                <div className={b('list')}>
                    {availableLanguages
                        .filter(languageCode => languageCode !== language)
                        .map(languageCode => {
                            const switchUrl = langSwitchUrl(
                                tld,
                                languageCode,
                                fullUrl,
                                secretkey,
                            );

                            return (
                                <Link
                                    className={b('switch')}
                                    href={switchUrl}
                                    key={languageCode}
                                    onClick={this.onLinkClick}
                                    data-language={languageCode}
                                >
                                    <span className={b('flag')}>
                                        <CountryFlag
                                            className={b('flag')}
                                            countryCode={
                                                COUNTRY_CODES[languageCode]
                                            }
                                        />
                                    </span>

                                    {LANGUAGE_TITLES[languageCode]}
                                </Link>
                            );
                        })}
                </div>
            </div>
        );
    }
}
