import React, {
    ReactElement,
    ReactNode,
    memo,
    SyntheticEvent,
    useContext,
} from 'react';
import B from 'bem-cn-lite';

import getCrowdTestingUrl from '../../lib/url/getCrowdTestingUrl';

import StaticContext from '../StaicContext/StaticContext';

const b = B('Link');

export interface ILink {
    href?: string;
    className?: string;
    children?: ReactNode;
    colors?:
        | 'inherit'
        | 'minorGray'
        | 'travel'
        | 'textPrimary'
        | 'textSecondary'
        | 'linkSecondary';
    target?: '_blank' | '_self';
    rel?: 'nofollow';
    style?: React.HTMLAttributes<HTMLAnchorElement>['style'];
    onClick?: (e: SyntheticEvent<HTMLElement>) => void;
    title?: string;
    textDecoration?: 'underline';
}

export default memo(Link);

function Link({
    className = '',
    colors,
    children,
    onClick,
    textDecoration,
    ...props
}: ILink): ReactElement {
    const {isCrowdTesting} = useContext(StaticContext);

    if (isCrowdTesting && props.href) {
        props.href = getCrowdTestingUrl(props.href);
    }

    return (
        <a
            {...props}
            className={b({colors, textDecoration}, className)}
            onClick={onClick}
        >
            {children}
        </a>
    );
}
