import {React, Component, B} from '../base';

import {connect} from 'react-redux';

import IconGlyph from '../../interfaces/components/IconGlyph';

import {getToday} from '../../lib/date/utils';
import searchUrl from '../../lib/url/searchUrl';
import {reachGoal} from '../../lib/yaMetrika';

import Link from '../Link';
import Icon from '../Icon/Icon';

import keyset from '../../i18n/link-backward';
import {getSearchTitle} from '../../lib/search/getSearchTitle';

const b = B('LinkBackward');

const mapStateToProps = ({tld, language}) => ({
    tld,
    language,
});

class LinkBackward extends Component {
    static defaultProps = {
        compact: false,
    };

    onClick() {
        reachGoal('link_backward_click');
    }

    getUrl() {
        const {context, currencies, sort, filtering, tld, language} =
            this.props;
        const {from, originalFrom, to, originalTo} = context;

        return searchUrl(
            {
                context: {
                    ...context,
                    from: to,
                    originalFrom: originalTo,
                    to: from,
                    originalTo: originalFrom,
                    searchNext: false,
                },
                sort,
                filtering,
                currencies,
            },
            tld,
            language,
        );
    }

    getTitle() {
        const {context, isRedesigned} = this.props;

        if (isRedesigned) {
            return getSearchTitle({
                from: context.to,
                to: context.from,
                transportType: context.transportType,
            });
        }

        const {when, time} = context;

        if (when.date) {
            const dateTitle = getToday({
                now: when.date,
                timezone: time.timezone,
            })
                .format(keyset('date-format'))
                .toLowerCase();

            return keyset('title', {date: dateTitle});
        }

        return keyset('title-all');
    }

    render() {
        const {compact, isRedesigned} = this.props;
        const title = this.getTitle();

        return (
            <span className={b({compact, redesigned: isRedesigned})}>
                <Link
                    className={b('link')}
                    href={this.getUrl()}
                    target="_blank"
                    onClick={this.onClick}
                >
                    <figure className={b('iconFigure')} aria-label={title}>
                        <Icon
                            className={b('icon')}
                            glyph={IconGlyph.backward}
                        />
                    </figure>

                    {!compact && (
                        <span className={b('title')} data-nosnippet>
                            {title}
                        </span>
                    )}
                </Link>
            </span>
        );
    }
}

export default connect(mapStateToProps)(LinkBackward);
