import React, {memo} from 'react';
import B from 'bem-cn-lite';

import Link from '../Link';

const b = B('LinksBlock');

interface ILinksBlockLink {
    href: string;
    text: string;
}

interface ILinksBlock {
    title: string;
    links: ILinksBlockLink[];

    className?: string;
}

export default memo(LinksBlock);

function LinksBlock({
    title,
    links,

    className,
}: ILinksBlock): React.ReactElement | null {
    if (!links.length) {
        return null;
    }

    return (
        <div className={b({}, className)}>
            <div className={b('header')}>{title}</div>

            <ul className={b('list')}>
                {links.map((link, index) => {
                    return (
                        <li className={b('item')} key={index}>
                            <Link href={link.href}>{link.text}</Link>
                        </li>
                    );
                })}
            </ul>
        </div>
    );
}
