import React from 'react';
import B from 'bem-cn-lite';

import {IWithClassName} from '../../interfaces/components/IWithClassName';

import Icon from '../Icon/Icon';
import IconGlyph from '../../interfaces/components/IconGlyph';

import disclamersKeyset from '../../i18n/disclaimers';

const b = B('LocalTime');

const LocalTime: React.FC<IWithClassName> = ({className}) => (
    <div className={b({}, className)}>
        <Icon className={b('clockIcon')} glyph={IconGlyph.clock} />
        {disclamersKeyset('local-time')}
    </div>
);

export default LocalTime;
