import React, {memo} from 'react';
import B from 'bem-cn-lite';

import IconGlyphInformers from '../../interfaces/components/IconGlyphInformers';

import Icon from '../Icon/Icon';

import stationKeyset from '../../i18n/station';

const b = B('LocalTimeDisclaimer');

const DEFAULT_SIZE = 'm';

interface ILocalTimeDisclaimer {
    size?: 'm';
    className?: string;
}

export default memo(LocalTimeDisclaimer);

function LocalTimeDisclaimer({
    size = DEFAULT_SIZE,
    className,
}: ILocalTimeDisclaimer): React.ReactElement {
    return (
        <div className={b({size}, className)}>
            <Icon className={b('icon')} glyph={IconGlyphInformers.alert2} />
            {stationKeyset('local-time-disclaimer')}
        </div>
    );
}
