import {React, Component, B} from '../base';

import keyset from '../../i18n/login-button';
import passportUrl from '../../lib/url/passportUrl';
import {decodeSpecialCharacters} from '../../lib/stringUtils';

import Icon from '../Icon/Icon';
import Link from '../Link';
import IconGlyph from '../../interfaces/components/IconGlyph';

const b = B('LoginButton');

export default class LoginButton extends Component {
    render() {
        const {tld, fullUrl} = this.props;
        const retpath = decodeSpecialCharacters(fullUrl);

        return (
            <Link
                className={b()}
                href={passportUrl(tld, 'auth', {retpath, from: 'rasp'})}
            >
                <span className={b('text')}>{keyset('text')}</span>

                <figure className={b('iconFigure')} aria-label={keyset('text')}>
                    <Icon className={b('icon')} glyph={IconGlyph.login} />
                </figure>
            </Link>
        );
    }
}
