import {React, PureComponent, B} from '../base';

import Time from '../Time/Time';

const b = B('StationSegmentModal');

export default class StationSegmentModal extends PureComponent {
    render() {
        const {time, dateFormat, station} = this.props;

        const {title} = station;

        return (
            <div className={b()}>
                <div className={b('time')}>
                    <Time className={b('local')} timeMoment={time} />

                    <Time
                        className={b('date')}
                        timeMoment={time}
                        format={dateFormat}
                    />
                </div>

                <span className={b('station')}>{title}</span>
            </div>
        );
    }
}
