import {React, PureComponent, B, mix} from '../base';

import StationSegmentModal from './StationSegmentModal';

import {HUMAN_SHORT} from '../../lib/date/formats';

const b = B('TimeAndStationsModal');

export default class TimeAndStationsModal extends PureComponent {
    static defaultProps = {
        dateFormat: HUMAN_SHORT,
    };

    render() {
        const {
            stationTo,
            stationFrom,

            arrivalMoment,
            departureMoment,
            dateFormat,

            className,
        } = this.props;

        return (
            <div className={mix(b(), className)}>
                <StationSegmentModal
                    className={b('stationFrom')}
                    time={departureMoment}
                    dateFormat={dateFormat}
                    station={stationFrom}
                />

                <StationSegmentModal
                    className={b('stationTo')}
                    time={arrivalMoment}
                    dateFormat={dateFormat}
                    station={stationTo}
                />
            </div>
        );
    }
}
